<?php $__env->startSection('title'); ?>
    Bulk Edit
    <?php echo \Illuminate\View\Factory::parentPlaceholder('title'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('header_right'); ?>
    <a href="<?php echo e(URL::previous()); ?>" class="btn btn-sm btn-primary pull-right">
        <?php echo e(trans('general.back')); ?></a>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-8 col-md-offset-2">

            <form class="form-horizontal" method="post" action="<?php echo e(route('models.bulkedit.store')); ?>" autocomplete="off" role="form">
                <?php echo e(csrf_field()); ?>


                <div class="box box-default">
                    <div class="box-body">

                        <div class="callout callout-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <?php echo e(trans_choice('admin/models/message.bulkedit.warn', count($models), ['model_count' => count($models)])); ?>

                        </div>


                        <table class="table">
                            <tbody>
                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr<?php echo (($model->assets_count > 0 ) ? ' class="warning"' : ' class="success"'); ?>>
                                    <td>
                                        <i class="fa <?php echo (($model->assets_count > 0 ) ? 'fa-warning info' : 'fa-check success'); ?>"></i>
                                        <?php echo e($model->display_name); ?>


                                            <?php if($model->model_number): ?>
                                                (<?php echo e($model->model_number); ?>)
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($model->assets_count); ?> assets
                                    </td>
                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>

                        <div class="col-md-12" style="padding-top: 20px;">
                            <!-- manufacturer -->
                            <?php echo $__env->make('partials.forms.edit.manufacturer-select', ['translated_name' => trans('general.manufacturer'), 'fieldname' => 'manufacturer_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            <!-- category -->
                            <?php echo $__env->make('partials.forms.edit.category-select', ['translated_name' => trans('admin/categories/general.category_name'), 'fieldname' => 'category_id', 'required' => 'true', 'category_type' => 'asset'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            <!-- custom fields -->
                            <div class="form-group <?php echo e($errors->has('fieldset_id') ? ' has-error' : ''); ?>">
                                <label for="category_id" class="col-md-3 control-label">
                                    <?php echo e(trans('admin/models/general.fieldset')); ?>

                                </label>
                                <div class="col-md-7">
                                    <?php echo e(Form::select('fieldset_id', $fieldset_list , old('fieldset_id', 'NC'), array('class'=>'select2 js-fieldset-field', 'style'=>'width:350px'))); ?>

                                    <?php echo $errors->first('fieldset_id', '<span class="alert-msg" aria-hidden="true"><br><i class="fas fa-times"></i> :message</span>'); ?>

                                </div>
                            </div>

                            <!-- depreciation -->

                            <div class="form-group <?php echo e($errors->has('depreciation_id') ? ' has-error' : ''); ?>">
                                <label for="category_id" class="col-md-3 control-label">
                                    <?php echo e(trans('general.depreciation')); ?>

                                </label>
                                <div class="col-md-7">
                                    <?php echo e(Form::select('depreciation_id', $depreciation_list , old('depreciation_id', 'NC'), array('class'=>'select2', 'style'=>'width:350px'))); ?>

                                    <?php echo $errors->first('depreciation_id', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                                </div>
                            </div>

                            <!-- requestable -->
                                <div class="form-group<?php echo e($errors->has('requestable') ? ' has-error' : ''); ?>">
                                    <div class="col-md-7 col-md-offset-3">

                                        <label for="requestable_nochange" class="form-control">
                                            <?php echo e(Form::radio('requestable', '', true, ['id' => 'requestable_nochange', 'aria-label'=>'requestable_nochange'])); ?>

                                            <?php echo e(trans('admin/hardware/general.requestable_status_warning')); ?>

                                        </label>
                                        <label for="requestable" class="form-control">
                                            <?php echo e(Form::radio('requestable', '1', old('requestable'), ['id' => 'requestable', 'aria-label'=>'requestable'])); ?>

                                            <?php echo e(trans('admin/hardware/general.requestable')); ?>

                                        </label>
                                        <label for="not_requestable" class="form-control">
                                            <?php echo e(Form::radio('requestable', '0', old('requestable'), ['id' => 'not_requestable','aria-label'=>'not_requestable'])); ?>

                                            <?php echo e(trans('admin/hardware/general.not_requestable')); ?>

                                        </label>


                                    </div>
                                </div>

                            <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" name="ids[<?php echo e($model->id); ?>]" value="<?php echo e($model->id); ?>">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div> <!--/.box-body-->

                    <div class="box-footer text-right">
                        <a class="btn btn-link pull-left" href="<?php echo e(URL::previous()); ?>" method="post" enctype="multipart/form-data"><?php echo e(trans('button.cancel')); ?></a>
                        <button type="submit" class="btn btn-success" id="submit-button"><i class="fas fa-check icon-white" aria-hidden="true"></i> <?php echo e(trans('general.update')); ?></button>
                    </div><!-- /.box-footer -->
                </div> <!--/.box.box-default-->
            </form>
        </div> <!--/.col-md-8-->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1608233/public_html/assets/resources/views/models/bulk-edit.blade.php ENDPATH**/ ?>